#include "MTCJBOViewer.h"

// typeids are probably byte-swapped (CJBO -> OBJC, RAHC -> CHAR)
// but it doesn't really matter

/*** OBJC resource structure **************************************************
 *	
 *	UInt32	fileType;	// 'OBJC' (byte-swapped)
 *	UInt32	dataSize;	// size of the following data
 *	UInt32	unknown;	// usually 0x27
 *	
 *	then follows the embedded data
 *	
 *	UInt32	subSize;	// size of following data
 *	UInt32	subType;	// type of following data
 *	
 *	if subType is 'DOOR'
 *	
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	char	name[0x40];	// last byte seems to contain index... why?
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	char	graphicName[0x40];		// probably wrong
 *	char	descriptionName[0x40];	// probably wrong
 *	UInt32	unknown;
 *	
 *	if subType is 'CHAR'
 *	
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	char	characterType[0x40];
 *	char	name[0x80];
 *	char	deathScript[0x80];	// length unknown
 *	UInt8	unknown[0xB8];	// yes, more unknown data, mainly because previous
 *							// field length is unknown
 *
 *	if subType is 'FLAG'
 *	
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	UInt32	unknown;
 *	float	unknown;
 *	float	unknown;
 *	float	unknown;
 *	UInt32	unknown;
 *	UInt8	filler[0x80];
 *	
 *	embedded data repeats until the end of the file?
 *	
 *****************************************************************************/

// *crosses fingers*
// let's see what SimpleResourceTemplate can do...

// NEUT (neutral characters) are variable length and currently unsupported
// also skipping patrol path and sound for now

#define END_OFFSET	0x6F

MTSimpleResourceTemplate MTCJBOViewer::kCJBOFormatTemplate =
{
	{
/*00*/	{	kTypeUInt32,						"Type" },
/*01*/	{	kTypeUInt32,						"Data Size" },
/*02*/	{	kTypeUInt32,						"Unknown" },
		
/*03*/	{	kTypeStoreConstantToVariable |
			DATA_AREA_1(0) |
			DATA_AREA_2(0x3FF),					"Number of Entries" },	// hack
		
/*04*/	{	kTypeStartSection | DATA_AREA_1(0),	"Entries" },
		
/*05*/	{	kTypeUInt32 |
			kTypeStoreToVariable |
			DATA_AREA_1(2),						"Entry Size" },
/*06*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"character (CHAR)",
												INFO_DATA_AREA(0x17),
												'CHAR' },
		

/*07*/	{	kTypeUInt32,						"Entry Type" },
/*08*/	{	kTypeUInt32,						"Unknown" },
/*09*/	{	kTypeUInt32,						"Unknown" },
/*0A*/	{	kTypeFloat,							"x" },
/*0B*/	{	kTypeFloat,							"y" },
/*0C*/	{	kTypeFloat,							"z" },
/*0D*/	{	kTypeFloat,							"rotx" },
/*0E*/	{	kTypeFloat,							"roty" },
/*0F*/	{	kTypeFloat,							"rotz" },
/*10*/	{	kTypeUInt32,						"Unknown" },
/*11*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x40),					"Character Type" },
/*12*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x20),					"Name" },
/*13*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x60),					"Starting Weapon" },
/*14*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x80),					"Death Script" },
/*15*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeHexDump),	"Unknown Data",	0, 0xB8 },
		
/*16*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*17*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"door (DOOR)",
												INFO_DATA_AREA(0x2B),
												'DOOR' },

/*18*/	{	kTypeUInt32,						"Entry Type" },
/*19*/	{	kTypeUInt32,						"Unknown" },
/*1A*/	{	kTypeUInt32,						"Unknown" },
/*1B*/	{	kTypeFloat,							"x" },
/*1C*/	{	kTypeFloat,							"y" },
/*1D*/	{	kTypeFloat,							"z" },
/*1E*/	{	kTypeFloat,							"rotx" },
/*1F*/	{	kTypeFloat,							"roty" },
/*20*/	{	kTypeFloat,							"rotz" },
/*21*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x40),					"Name" },
/*22*/	{	kTypeUInt32,						"Unknown" },
/*23*/	{	kTypeUInt32,						"Unknown" },
/*24*/	{	kTypeUInt32,						"Unknown" },
/*25*/	{	kTypeUInt32,						"Unknown" },
/*26*/	{	kTypeUInt32,						"Unknown" },
/*27*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x40),					"Graphic Name" },
/*28*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x40),					"Description Name" },
/*29*/	{	kTypeUInt32,						"Unknown" },
		
/*2A*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*2B*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"flag (FLAG)",
												INFO_DATA_AREA(0x3A),
												'FLAG' },
		
/*2C*/	{	kTypeUInt32,						"Entry Type" },
/*2D*/	{	kTypeUInt32,						"Unknown" },
/*2E*/	{	kTypeUInt32,						"Unknown" },
/*2F*/	{	kTypeFloat,							"x" },
/*30*/	{	kTypeFloat,							"y" },
/*31*/	{	kTypeFloat,							"z" },
/*32*/	{	kTypeFloat,							"rotx" },
/*33*/	{	kTypeFloat,							"roty" },
/*34*/	{	kTypeFloat,							"rotz" },
/*35*/	{	kTypeUInt16,						"Unknown" },
/*36*/	{	kTypeUInt16,						"Unknown" },
/*37*/	{	kTypeUInt32,						"Unknown" },
/*38*/	{	kTypeSpecialType |
			kTypeIsFiller |
			DATA_AREA_1(kCustomTypeHexDump),	"Unknown Data",	0, 0x80 },
		
/*39*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*3A*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"furniture (FURN)",
												INFO_DATA_AREA(0x46),
												'FURN' },
		
/*3B*/	{	kTypeUInt32,						"Entry Type" },
/*3C*/	{	kTypeUInt32,						"Unknown" },
/*3D*/	{	kTypeUInt32,						"Unknown" },
/*3E*/	{	kTypeFloat,							"x" },
/*3F*/	{	kTypeFloat,							"y" },
/*40*/	{	kTypeFloat,							"z" },
/*41*/	{	kTypeFloat,							"rotx" },
/*42*/	{	kTypeFloat,							"roty" },
/*43*/	{	kTypeFloat,							"rotz" },
/*44*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x50),					"Name" },
		
/*45*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*46*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"particle (PART)",
												INFO_DATA_AREA(0x56),
												'PART' },
		
/*47*/	{	kTypeUInt32,						"Entry Type" },
/*48*/	{	kTypeUInt32,						"Unknown" },
/*49*/	{	kTypeUInt32,						"Unknown" },
/*4A*/	{	kTypeFloat,							"x" },
/*4B*/	{	kTypeFloat,							"y" },
/*4C*/	{	kTypeFloat,							"z" },
/*4D*/	{	kTypeFloat,							"rotx" },
/*4E*/	{	kTypeFloat,							"roty" },
/*4F*/	{	kTypeFloat,							"rotz" },
/*50*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x40),					"Particle Type" },
/*51*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x30),					"Name" },
/*52*/	{	kTypeUInt32,						"Unknown" },
/*53*/	{	kTypeUInt32,						"Unknown" },
/*54*/	{	kTypeUInt32,						"Unknown" },
		
/*55*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },

/*56*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"powerup (PWRU)",
												INFO_DATA_AREA(0x62),
												'PWRU' },
		
/*57*/	{	kTypeUInt32,						"Entry Type" },
/*58*/	{	kTypeUInt32,						"Unknown" },
/*59*/	{	kTypeUInt32,						"Unknown" },
/*5A*/	{	kTypeFloat,							"x" },
/*5B*/	{	kTypeFloat,							"y" },
/*5C*/	{	kTypeFloat,							"z" },
/*5D*/	{	kTypeFloat,							"rotx" },
/*5E*/	{	kTypeFloat,							"roty" },
/*5F*/	{	kTypeFloat,							"rotz" },
/*60*/	{	kTypeUInt32,						"Powerup Type" },
		
/*61*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*62*/	{	kTypeUInt32 |
			kTypeIsFiller |
			kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpIf) |
			DATA_AREA_2(kCustomTypeJumpIfNotEqual | kCustomTypeJumpIfNoAdvance),
												"weapon (WEAP)",
												INFO_DATA_AREA(0x6E),
												'WEAP' },
		
/*63*/	{	kTypeUInt32,						"Entry Type" },
/*64*/	{	kTypeUInt32,						"Unknown" },
/*65*/	{	kTypeUInt32,						"Unknown" },
/*66*/	{	kTypeFloat,							"x" },
/*67*/	{	kTypeFloat,							"y" },
/*68*/	{	kTypeFloat,							"z" },
/*69*/	{	kTypeFloat,							"rotx" },
/*6A*/	{	kTypeFloat,							"roty" },
/*6B*/	{	kTypeFloat,							"rotz" },
/*6C*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeCString) |
			DATA_AREA_2(0x20),					"Weapon Type" },
				
/*6D*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeJumpAbs),
												"jump to end",
												INFO_DATA_AREA(END_OFFSET) },
		
/*6E*/	{	kTypeSpecialType |
			DATA_AREA_1(kCustomTypeRegisterOp) |
			DATA_AREA_2(kCustomTypeROpSkip),
												"skip(r2);",
												ROP_EXTEND(2, 0, 0) },
		
/*6F*/	{	kTypeEndSection },
		
/*70*/	{	0 }
	}
};
